
************************************************
** UKUS dataset for Housing Pathways for natives and non-natives (Waves 1-7) 
** date: 22/01/2018
** Author: Olayiwola 
** NOTE: Change necessary dirs before executing
************************************************
//set directory
version 15
clear all
set more off
capture log close
cd "C:\Users\wg847401\OneDrive - University of Reading\oldfiles\Desktop\PhD\iCUL Project\Analysis and models\secondary data\BHPS UKLS\Dataset breakdown"
cd "C:\Users\layi4\University of Reading\OneDrive - University of Reading\oldfiles\Desktop\PhD\iCUL Project\Analysis and models\secondary data\BHPS UKLS\Dataset breakdown"

 
 
 *Set maxvar
set maxvar 32767
log using BHPS1-18merge.log, replace

//create empty temp and dta dirs if they don't exist
	*Note: 'temp' directory is deleted at the end
capture confirm file "./temp/nul"
if _rc!=0 {
	mkdir "./temp"
}
capture confirm file "./dta/nul"
if _rc!=0 {
	mkdir "./dta"
}



***************************************
******1. BHPS indresp data ********
****************************************
** Merging BHPS indresp data
*Set maxvar

** rename variables (exclude wave prefix) **
local i=1
foreach xx in ba bb bc bd be bf bg bh bi bj bk bl bm bn bo bp bq br{
	di "counter = `i'"
	use "`xx'_indresp.dta", clear
	renvars `xx'_*, presub(`xx'_)
	gen wave = `i'
	lab var wave "wave of BHPS Ind interview"
	save "./temp/`xx'_bhindresp2.dta", replace
	local i = `i'+1
}
clear

** combine w_indresp2.dta from waves 1-18 **
use "./temp/br_bhindresp2.dta", clear
foreach xx in ba bb bc bd be bf bg bh bi bj bk bl bm bn bo bp bq {
	append using "./temp/`xx'_bhindresp2.dta"
}
sort pidp wave, stable //sort by cross-wave identifier and wave
save "./dta/bhindresp2_all7w.dta", replace



*****Merging bhps hhresp data****

** rename variables (exclude wave prefix) **
local i=1
foreach xx in ba bb bc bd be bf bg bh bi bj bk bl bm bn bo bp bq br{
	di "counter = `i'"
	use "`xx'_hhresp.dta", clear
	renvars `xx'_*, presub(`xx'_)
	gen wave = `i'
	lab var wave "wave of BHPS interview"
	save "./temp/`xx'_bhhhresp1.dta", replace
	local i = `i'+1
}
clear

** combine w_hhresp1.dta from waves 1-18 **
use "./temp/br_bhhhresp1.dta", clear
foreach xx in ba bb bc bd be bf bg bh bi bj bk bl bm bn bo bp bq {
	append using "./temp/`xx'_bhhhresp1.dta"
}
sort hidp wave, stable //sort by cross-wave identifier and wave
save "./dta/bhhhresp1_all7w.dta", replace



*****Merging bhps hhresp, indresp and xwavedat data***
use "./dta/bhindresp2_all7w.dta", clear
mmerge hidp using "./dta/bhhhresp1_all7w.dta", table

*Drop those not fully merged missing (merge==1)
drop if _merge==2
rename _merge _m_ihh
save "./temp/bhindhh.dta", replace
clear

** import fixed vars & merge with ind_hh_all4.dta **
*check which variables bring in and whether they exist already...........................
use "./temp/bhindhh.dta", clear
mmerge pidp using "xwavedat", table
drop _merge 
save "./dta/BHPS.dta", replace




****************************************
******2. Understanding Society Wave 1-7 ********
****************************************

** Merging UKLS indresp data
** rename variables (exclude wave prefix) **
local i=1
foreach x in a b c d e f g{
	di "counter = `i'"
	use "`x'_indresp.dta", clear
	renvars `x'_*, presub(`x'_)
	gen wave = `i'
	lab var wave "wave of UKLS interview"
	save "./temp/`x'_usindresp2.dta", replace
	local i = `i'+1
}
clear

** combine w_indresp2.dta from waves 1-7 **
use "./temp/g_usindresp2.dta", clear
foreach x in a b c d e f {
	append using "./temp/`x'_usindresp2.dta"
}
sort pidp wave, stable //sort by cross-wave identifier and wave
save "./dta/usindresp2_all7w.dta", replace


** Merging UKLS hhresp data
** rename variables (exclude wave prefix) **
local i=1
foreach x in a b c d e f g{
	di "counter = `i'"
	use "`x'_hhresp.dta", clear
	renvars `x'_*, presub(`x'_)
	gen wave = `i'
	lab var wave "wave of UKLS interview"
	save "./temp/`x'_ushhresp1.dta", replace
	local i = `i'+1
}
clear
** combine w_hhresp1.dta from waves 1-18 **
use "./temp/g_ushhresp1.dta", clear
foreach x in a b c d e f {
	append using "./temp/`x'_ushhresp1.dta"
}
sort hidp wave, stable //sort by cross-wave identifier and wave
save "./dta/ushhresp1_all7w.dta", replace

*

** Merging UKLS indresp, hhresp 
use "./dta/usindresp2_all7w.dta", clear
mmerge hidp using "./dta/ushhresp1_all7w.dta", table

*Drop those not fully merged missing (merge==1)
drop if _merge==1 | _merge==2
rename _merge _m_ihh
save "./temp/uklsindhh.dta", replace
clear

** import fixed vars & merge with ind_hh_all4.dta **
*check which variables bring in and whether they exist already...........................
use "./temp/uklsindhh.dta", clear
mmerge pidp using "xwavedat", table 
drop _merge 
save "./dta/UKLS.dta", replace


****************************************
******3. Create harmonised wave variable for bhps and UKLS ********
****************************************

***create harmonised wave variable 
**harmonised wave variable for bhps 
use "./dta/BHPS.dta", clear
gen hwave = wave + 0
lab var hwave "Harmonised BHPS and UKLS wave"
save "./dta/BHPS.dta", replace
clear


**harmonised wave variable for UKLS
use "./dta/UKLS.dta", clear
gen hwave = wave + 18
lab var hwave "Harmonised BHPS and UKLS wave"
save "./dta/UKLS.dta", replace
clear



*********************************************************
******4. Merge BHPS and UKLS   ********
*********************************************************
use "./dta/BHPS.dta", clear
append using "./dta/UKLS.dta"
sort pidp hwave
save "./dta/BHPS_UKLS.dta", replace
clear







** keep varlist 
use "./dta/BHPS_UKLS.dta", clear



***key variables
keep age_dv pid hiqual_dv hid pno istrtdatd istrtdatm istrtdaty ivlyr ivstat2 lknbrd lkmove ///
lkmovy xpmove plnew plnowm plnowy4 movjb movjba movjbb movjbc movjbd movjbe ///
movjbf movjbg movjbh movjbi movy1 movy2 doby sex mlstat_bh mlchy4 jbstat yr2uk4 ///
natidb natidf natidg natide natida natidh racel_bh paju_bh pasemp paboss pamabrn ///
maju_bh masemp maboss mamngr j1none_bh j1semp j1boss j1mngr lprnt lnprnt ///
school scend scnow fenow_bh fetype feend qfhas ivlpar nrptim wlshub wlshua wlshuc ///
nrpart wlshud wlshue aglt20 scnow2 pabrn mabrn papabrn pamabrn mapabrn mamabrn ///
ivda ivdb ivdc ivdd hldsbl1 jbhas jboff jboffy_bh jbterm1 jbterm2_bh jbck1 jbsocp ///
jbsocr jbsicp jbsic92 jbprom jbchgy4 jbpl_bh jbttwt jbttwm jbsat2 jbsat4 jbsat6 ///
jbsat7 jbsat_bh paygl paygw paynl paynw pytc pywftc pywftcw payslp payu payusl ///
payuw payug paytyp_bh jspl_bh jsttwtb jsttwm jssat1 jssat2 jssat4 jssat5 jssat ///
jblkchd jbxpchc jblkchc jbxpchb jbxpchd jblkche jbxpche rach12 eaage opnatb opnate ///
vote1 vote2 vote3_bh vote4_bh vote5 vote7 vote8_bh vote6 oprlg5 oprlg7 oprlg1_bh ///
lactb lactc lactd lacte lactf lacth lactl lactk frna frnb frnc lfimpa lfimpb lfimpc ///
lfimpd lfimpe lfimpf lfimpg lfimph locsera locserb locserc locserd locsere locchd ///
opngbha opngbhb opngbhc opngbhg opngbhf opngbhe opngbhh grnlff save savreg savlt ///
neigh neigh1 neigh2 neigh3 neigh4 ivfa ivfb ivfc ivfd ivfe lfsat1 lfsat2 lfsat3 ///
lfsat4 lfsat5 lfsat6 lfsat7 lfsat8 lfsato lfsatl sctrust riska net1et net2et net3et ///
tlhqly telhtq hhmem memorig_bh hgsex birthy mastat ppno hgbiof hgbiom nchild_dv hoh ///
rach16_dv sampst_bh movest region hhsize hhtype tenure_dv qfedhi qfvoc qfachi jbft ///
payg_dv payn_dv paygu_dv paynu_dv paygty paygly paynty paynly jbsoc90ly jlseg vote ///
fihhmn scghq1_dv scghq2_dv spjb sppayg mrjend mrjsoc mrjsic fnpid_bh mnpid_bh jbbgy  ///
jbbgy distmov gor_dv pidp hidp netph_1 macob pacob pgmrob pgprob mgmrob mgprob ///
hhorig memorig oprlg oprlg1 sampst mlstat plbornc vote3 vote4 vote8 paytyp jbpl ///
jbterm2 jspl ukcitzn_dv_bh wave plb4c yr2uk jblky1 jbstat_bh race orgm1 orga1 orgm2 ///
orga2 orgm3 orga3 orgm4 orga5 orgm5 orgm6 orga4 orgm6 orga6 orgm7 orga7 orgm11 orga11 ///
orgm12 orga12 orgm13 orga13 oppol1 savey huboss hgest mlchy hlsf10d paynmw1 opeur2 ///
opeur4 lngeng lngoth lngusa lngusb nvestnn retex agexrt agelh_bh paby paagyb maby ///
maagyb paedqf maedqf swpop2 agelh ///
hidp wave sex agegr10_dv agegr13_dv agegr5_dv basnsa ///
     country employ envhabit* fenow fimngrs_dv finfut finnow fiyrinvinc_dv ///
	 fnpno fnspid  gor_dv hidp indscus_lw indscus_xw istrtdat* jbbg* jbes2000 ///
	 jbft_dv jbmngr jbpl jbsec* jbsat jbstat jbseg_dv jbsemp jbterm1 jbterm2 ///
	 jbttwt livesp_dv marstat mastat_dv mlstat mnpno mnspid nchild_dv ///
	 hiqual_dv qfhigh_dv nnatch paygu_dv paynu_dv pid pidp pno hidp ///
	 hhorig memorig psu ppid ppno prearna scenv_* sclfsato  ///
	 sppid sppno strata vote* per* poleff3 nc* yr2uk4 citzn1 citzn2 citzn3 qfh* ///
	 edtype pacob payruk macob mayruk natid1 natid2 natid3 natid4 natid5 ///
	 natid6 natid97 racel racelt racelwt racelmt  racelat racelbt oprlg oprlg0ni ///
	 nirel niact llknbrd locserap locseras locserb locserd locsere servacc ///
	 nbrcoh3 nbrcoh4 crwora crworb crdark simage simrace simeduc simjob ///
	 siminc simarea netcht cjob jbbgdaty jbbgdatm jbbgm jbbgy jbsectpub ///
	 jbsect payu payug worktrav save savreg saved ppen livesp ///
	 lingua plieng prearn dvage2uk age2ukc dv2uk16 lkmvcntry xpmvcntry indeflv ///
	 intendukc citznwhen citznyear higheduk qfhighoth cntryqual qfvocuk qfvocnonuk ///
	 payruk1 pacurr mayruk1 macurr pgprob pgmrob mgprob mgmrob paedqf  maedqf ///
	 pajuk pajukevr majuk pajcb majukevr enguk englang kidlang mabroad mnabroad ///
	 mindirect mnotherc mreason1 mreason2 mreason3 mreason4 mreason5 mreason6 ///
	 mreason7 mreason97 mreturned mlived mnlived mnmoves mlivedist mlivedist5 ///
	 mlivedistf mintent mintwhen lcmarm j1ukjob j1cojob ncrr16 mreasono_code ///
	 qfctry hrpid hrpno cohab_dv single_dv payg_dv payn_dv payu_dv ///
	 seearngrs_dv seearnnet_dv qualoc qfvoc2 qfvoc3 qfvoc4 qfvoc11 qfvoc12 ///
	 qfvoc9 qfvoc10 qfvoc13 qfvoc14 qfvoc15 qfvoc15 qfvoc96 school scend schlloc ///
	 j1none j1semp j1boss j1mngr lieng litrans pdvage mvever mvmnth mvyr xpmove ///
	 lkmove xpmvwhr mlstatchk netpuse caruse ukborn plbornc lcmarm jbnssec8_dv  ndepchl_dv ///
wave hid intdatem intdatey hstype hsrins hsroom hsownd_bh hsowr1_bh hsowr2_bh ///
hsval mghave hsowrp mgynot_bh hscost hsyr04_bh mgyr04 mgly hsivlw mgold mglife ///
mgtype_bh mgextra mgnew mgxty1_bh mgxty2_bh mgxty3_bh mgxty4_bh mgxty5_bh xpmg ///
xpmg1 xpmg2 xpmg3 xpmg4 hsjb rentp1_bh rentp2_bh rentll rentf rent rentw rent1 ///
rent7 rent2 rent3 rent4 rent5 rent8 rent6 renthb_bh rentg_bh rentgw xphsdf xphsd1 ///
xphsd2 xphsdb_bh hskch hskchs hsbth hsbths hstlt hstlts hsgdn hsgdns xpgasy_bh ///
xplecy xpoily_bh xpsfly heatch heatyp solar1 solar2 solar3 gelec larcyc hhrcyc ///
hhbb hsprbg hsprbh hsprbi hsprbj hsprbk hsprbl hsprbm hsprbn hsprbo hsprbp hsprbq ///
hsctax hs2ownd hs2valo hs2vala hs2valb hs2valc hs2vald mgtot cdhave xphpdf hscana ///
hscnta hscanb hscntb hscank hscntk hscanl hscntl carown carval ivh1_bh ivh2_bh ///
ivh3_bh hhorig_bh hhdc xhwght hhsize hhtype region nch02_dv nch34_dv nch511_dv ///
nch1215_dv nch1618 nkids_dv nwed npens_dv na75pl agechy_dv ncouple_dv nonepar_dv ///
nemp_dv nwage_dv tenure_dv xphsn xphsg fieqfcb fieqfca fihhyr fihhmngrs_dv hhmove ///
xhwghte xhwtuk1 xhwtuk2 gor_dv hidp ivh0 ivh1 ivh2 ivh3 ivh4 ivh5 ivh6 ivh7 ivh8 ///
ivh9 ivh10 ivh11 ivh12 ivh13 ivh14 ivh15 rentp0 hsyr04 hsyrbuy xpgasy xphsdb xpoily ///
mgxty1 mgxty2 mgxty3 mgxty4 hhjnd wave nhhrsp hsbeds hssnip mgyr0 hsyr0 hsprba hsprbb ///
hsprbc hsprbd hsprbe hsprbf gasuse hhwght hsfloor ladistc nue xpoil xpgas xplec xpfuel ///
phone hsrooms mgstat hsivw1 hsivw2 hsipxp hsip cdnuxp mgstat hsivw2 hs2val hsivw3 hsivw4 ///
xpbldf hsivw5 xhwtsw1 xhwtsw2 hsivw9 nch02_dv nch1215_dv nch34_dv nch511_dv nkids_dv wave tenure_dv hhsize hhtype ///
hscost hsctax hsownd hsrooms hsval ///
fihhmngrs_dv hsyr04 ///
pidp mreason* dvage agegr13_dv dv2uk16 agegr5_dv agegr10_dv mreason5 jspayu pdvage dvage2uk age2uk ///
pid hidp pno childpno hhorig memorig psu strata sampst month quarter ivfio ioutcome sex dvage birthy nchunder16 ///
nch5to15 nch10to15 nch10 nunder16abs n1619abs nchresp nch14resp nch415resp nch3resp nch5resp nch8resp nadoptch ///
nnatch sibling istrtdaty istrtdatm lieng litrans pdvage mvever mvmnth mvyr lkmove xpmove xpmvwhn xpmvmnth ///
xpmvyr xpmvwhr jbstat mlstatchk mlstat drive caruse ukborn plbornc yr2uk4 citzn1 citzn2 citzn3 qfhigh qualoc qfvoc2 ///
qfvoc3 qfvoc4 qfvoc1 qfvoc4 qfvoc5 qfvoc6 qfvoc7 qfvoc8 qfvoc9 qfvoc10 qfvoc11 qfvoc13 qfvoc14 qfvoc96 school_cawi ///
school scend schlloc fenow_cawi fenow feend edtype hedlik ocimpa lvhm ocimpb ocimpe ocimpf ocimpi ocimpk ocimpl ///
paju maju pacob payruk macob mayruk natid1 natid2 natid3 natid4 natid5 natid6 natid97 racel racelo_code racelt racelwt ///
racelmt racelat racelbt racelot_code oprlg oprlg0ni nirel niact oprlg0 oprlg1 unsafe1 unsafe2 unsafe3 unsafe4 unsafe5 ///
unsafe6 unsafe7 unsafe8 unsafe9 unsafe10 unsafe11 unsafe96 unsafe97 unsafeo_code resunsafe1_1 resunsafe2_1 resunsafe3_1 ///
resunsafe4_1 resunsafe5_1 resunsafe6_1 resunsafe7_1 resunsafe8_1 resunsafe9_1 resunsafe96_1 resunsafe97_1 resunsafe1_2 ///
resunsafe2_2 resunsafe3_2 resunsafe4_2 resunsafe5_2 resunsafe6_2 resunsafe7_2 resunsafe8_2 resunsafe9_2 resunsafe96_2 ///
resunsafe97_2 resunsafe1_3 resunsafe3_3 resunsafe2_3 resunsafe4_3 resunsafe5_3 resunsafe6_3 resunsafe7_3 resunsafe8_3 ///
resunsafe9_3 resunsafe96_3 resunsafe97_3 resunsafe1_4 resunsafe2_4 resunsafe3_4 resunsafe4_4 resunsafe5_4 resunsafe6_4 ///
resunsafe7_4 resunsafe8_4 resunsafe9_4 resunsafe96_4 resunsafe97_4 resunsafe1_5 resunsafe2_5 resunsafe3_5 resunsafe4_5 ///
resunsafe5_5 resunsafe6_5 resunsafe7_5 resunsafe8_5 resunsafe9_5 resunsafe96_5 resunsafe97_5 resunsafe1_6 resunsafe2_6 ///
resunsafe3_6 resunsafe5_6 resunsafe6_6 resunsafe7_6 resunsafe8_6 resunsafe9_6 resunsafe96_6 resunsafe97_6 resunsafe1_7 ///
resunsafe2_7 resunsafe3_7 resunsafe4_7 resunsafe5_7 resunsafe6_7 resunsafe7_7 resunsafe8_7 resunsafe9_7 resunsafe96_7 ///
resunsafe97_7 resunsafe1_8 resunsafe2_8 resunsafe3_8 resunsafe4_8 resunsafe6_8 resunsafe7_8 resunsafe8_8 resunsafe9_8 ///
resunsafe96_8 resunsafe97_8 resunsafe1_9 resunsafe2_9 resunsafe4_9 resunsafe5_9 resunsafe6_9 resunsafe7_9 resunsafe8_9 ///
resunsafe9_9 resunsafe96_9 resunsafe97_9 resunsafe1_10 resunsafe2_10 resunsafe3_10 resunsafe4_10 resunsafe5_10 resunsafe6_10 ///
resunsafe7_10 resunsafe8_10 resunsafe9_10 resunsafe96_10 resunsafe97_10 resunsafe1_11 resunsafe2_11 resunsafe3_11 ///
resunsafe4_11 resunsafe5_11 resunsafe6_11 resunsafe7_11 resunsafe8_11 resunsafe9_11 resunsafe96_11 resunsafe97_11 ///
resunsafe1_12 resunsafe2_12 resunsafe3_12 resunsafe4_12 resunsafe5_12 resunsafe6_12 resunsafe7_12 resunsafe8_12 ///
resunsafe9_12 resunsafe96_12 resunsafe97_12 health ch1by4 lprnt lnprnt ch1by4 mabroad mabroadc2 mabroadc3 mabroadc4 ///
mabroadc5 mnabroad mindirect mnotherc mindirectc1 mindirectc2 mindirectc3 mindirectc4 mindirectc5 dvage2uk age2ukc ///
age2uk dv2uk16 mreason1 mreason2 mreason3 mreason4 mreason5 mreason6 mreason7 mreason97 mreasono_code mreturned mlived ///
mnlived mlivedc1 mlivedc2 mlivedc3 mlivedc4 mlivedc5 mnmoves mlivedist mlivedist5 mlivedistf mintent mintwhen adcts movy11 ///
movy12 movy13 movy14 movy15 movy16 family education memploy housing area moveoth_code movdir plnowm plnowy4 relup ///
mstatsam preg nchild qualnew1 qualnew2 qualnew3 qualnew4 qualnew5 qualnew6 qualnew7 qualnew8 qualnew9 qualnew10 qualnew11 ///
qualnew13 qualnew15 qualnew32 qualnew33 qualnew16 qualnew17 qualnew18 qualnew19 qualnew20 qualnew21 qualnew22 qualnew23 ///
qualnew24 qualnew25 qualnew26 qualnew27 qualnew28 qualnew29 qualnew30 qualnew31 trainn trqual1 trqual2 trqual3 trqual4 ///
trqual5 trqual6 trqual7 trqual8 trqual9 trqual10 trqual13 trqual11 trqual13 trqual15 trqual32 trqual32 trqual33 trqual16 ///
trqual17 trqual18 trqual19 trqual20 trqual21 trqual22 trqual23 trqual24 trqual25 trqual26 trqual27 trqual28 trqual29 ///
trqual30 trqual34 trqual31 notempchk empchk stendreas1 stendreas3 stendreas4 stendreas5 stendreas6 stendreas7 stendreas10 ///
stendreas11 stendreas97 nxtst cstat nxtstelse cjbatt jbhas jbsemp jbsempchk jbbgd jbbgm jbbgy jbmngrchk jbmngr jbsizechk ///
jbsize jbsect jbsectpub jbpl paygl paygwc paynl paynwc payusl payu payuwc payug paytyp jbttwt worktrav jsboss jssize ///
jshrs jstypeb jspl jsttwtb_cawi jsttwt jsworktrav jsttwtb jbsat jsworktrav jlsemp jlboss jlmngr jlsize eprosh maage ///
paage benbase2 benbase3 benbase4 benbase1 benbase96 benctc ageret retamt retsuf vote1 vote3 vote2 vote4 vote7 vote8 ///
sclfsat1 sclfsat2 sclfsat7 sclfsato marstat livesp livewith employ lingua sf1 prearn prearna sex_dv doby_dv age_dv ///
pensioner_dv npensioner_dv jbsocgr_dv scdata_dv racel_dv j2pay_dv country gor_dv urban_dv hhresp_dv xtra5min_dv ///
xtra5minosm_dv agegr5_dv agegr10_dv agegr13_dv livesp_dv cohab_dv single_dv mastat_dv hhtype_dv buno_dv depchl_dv ///
nchild_dv ndepchl_dv respm16_dv respf16_dv rach16_dv hrpid hrpno hrpno ppno sppid sppno fnpno fnpid fnspid fnspno ///
mnpno mnpid mnspid mnspno grfpno grfpid grmpno grmpid qfhigh_dv nqfhigh_dv qfhighfl_dv hiqual_dv nhiqual_dv nnmpsp_dv ///
nunmpsp_dv jbft_dv payg_dv unsafe_dv insulted_dv avoided_dv attacked_dv payn_dv payu_dv paygu_dv paygu_if paynu_dv ///
paynu_if seearngrs_dv seearnnet_dv seearngrs_if fiyrinvinc_dv fiyrinvinc_if fibenothr_dv fimngrs_dv indnsub_lw vote5 ///
vote6 indpxui_lw indinus_lw indinui_lw indscui_lw indscus_lw ind5mus_lw indin91_lw indin01_lw indpxub_lw indinub_lw ///
indpxub_xw indinub_xw indscub_xw indpxui_xw indinui_xw indscui_xw ind5mus_xw wave payruk1 mayruk1 pgprob pgmrob ///
mgprob mgmrob paedqf maedqf lvag16 agelh lvag14 ynlp14 paid spaid maid maid smaid britid englang engspk spkdif engtel ///
teldif engread readdif engform formdif moveage mpno workdis basnsa jbpen jbpenm retdatey retdatem promodeny respromodeny1 ///
respromodeny2 respromodeny3 respromodeny4 respromodeny5 respromodeny6 respromodeny7 respromodeny8 respromodeny9 ///
respromodeny96 respromodeny97 samsch btype1 btype2 btype3 btype4 btype5 btype6 btype7 btype8 btype9 bensta1 bensta8 ///
unsafew11 unsafew12 unsafew13 unsafew14 unsafew15 unsafew16 unsafew17 unsafew196 unsafew197 attackedw11 attackedw12 ///
attackedw13 attackedw14 attackedw15 attackedw16 attackedw17 attackedw196 attackedw197 nchund18resp nchund18resp scsex ///
scdoby4 scopngbha scopngbhb scopngbhc scopngbhd scopngbhe scopngbhf scopngbhg scopngbhh sctrust scriska scriskb scmolwp ivtrans ///
emboost gpcomp lda ageest adresp17 ethnic1 ethnic2 ethnic3 ethnic4 ethnic5 ethnic6 ethnic7 ethnic8 ethnic9 ethnic11 ethnic10 ///
ivintlang indinui_xw indinui_lw indscus_xw indpxus_xw indinus_xw cindtime newentrant lvyrp lvmthp adstatus chksex chkdob kidlang pride2 pride4a ///
pride4b pride6 pride7 pride5 pride8 pride9 pride10 pride11 pride12 pride13 pride14 twkdiff1 twkdiff2 twkdiff3 twkdiff4 twkdiff5 ///
twkdiff6 twkdiff7 twkdiff8 twkdiff97 twkdiffm twkcar twkcary1 twkcary2 twkcary3 twkcary4 twkcary5 twkcary6 twkcary7 twkcary8 ///
twkcary9 twkcary10 twkcary12 twkcary13 twkcary14 twkcary97 twkcarym wkphys jbperfp jbonus ethnic12 ethnic13 ethnic14 ethnic96 ///
mabroadc2 mabroadc3 mabroadc4 mabroadc5 mindirectc1 mindirectc2 mindirectc3 mindirectc4 mindirectc5 mlivedc1 mlivedc2 mlivedc3  ///
mlivedc4 mlivedc5 mabroadc1 mintent migration_tm ///
wave sex age_dv adstatus agegr10_dv agegr13_dv agegr5_dv basnsa ///
country employ fenow fimngrs_dv fiyrinvinc_dv ///
fnpno fnspid  gor_dv hidp indscus_lw indscus_xw istrtdat* jbbg* ///
jbft_dv jbmngr jbpl jbsec* jbsat jbstat jbsemp ///
jbttwt livesp_dv marstat mastat_dv mlstat mnpno mnspid nchild_dv ///
hiqual_dv qfhigh_dv nnatch paygu_dv paynu_dv pid pidp pno hidp ///
hhorig memorig psu pid ppno prearna sclfsato dvage2uk age2ukc dv2uk16 age2uk ///
hidp hhorig psu strata month quarter ivfho hglieng addrchck origadd mores hhsize ///
hhlang iemb fborn nkids05 nkids015 n10to15 nkids615 npensioner hgstrtdaty hgstrtdatm ///
hgstrtdatd hgstrtdathh hgenddaty hgenddatm hgenddatm hgenddatd modetype hlieng ///
hlitrans histrtdaty histrtdatm histrtdatd hsroomchk hsbeds hsrooms hsowndchk hsownd ///
hsowr10 hsval mgynot hsyrbuy hscost hsyr04 mgold mglife mgtype mgextra mgnew mgxty1 ///
mgxty2 hstotmg xpmg hsjb rentp0 rentll rentf rentinc1 rentinc2 rentinc3 rentwc rent ///
rentg fuelhave1 fuelhave2 fuelhave3 fuelhave4 fuelhave96 gaspay xpoily xpsfly heatch ///
hsctax xphsdb xphsdct xphsdba pcnet ncars outcome npensioner_dv ff_hsownd fihhmnnet1_dv ///
fihhmnlabgrs_dv fihhmnlabnet_dv fihhmnmisc_dv fihhmnprben_dv fihhmninv_dv fihhmnpen_dv ///
fihhmnsben_dv country gor_dv urban_dv urban_dv hhresp_dv hhtype_dv hrpid hrpno ncouple_dv ///
nonepar_dv nkids_dv nch02_dv nch34_dv nch511_dv agechy_dv nch1215_dv npens_dv nemp_dv nue_dv ///
nwage_dv nchoecd_dv nadoecd_dv ieqmoecd_dv tenure_dv fihhnegsei_if fihhmngrs_if fihhmngrs_dv ///
hhdenub_xw hhdenui_xw wave startdatd startdatm startdaty solar1 solar2 solar3 etariff rubrec ///
matdepa matdepb matdepd matdepe matdepf hheat cdephave1 cdephave2 cdephave3 cdephave4 cdepdo1 ///
cdepdo2 cdepdo3 cplay cdeptrp emboost gpcomp lda absent numadult numchild nunder15 nunder10 ///
hhdenus_xw ff_hhsize histrtdatss hhdenbh_xw noisyn grimyn ivlheng ivlhtrans nummpart numcivil ///
numlivewith hhstatus lheng lhtrans nch02_dv nch1215_dv nch34_dv nch511_dv nkids_dv ///
rubrec wave tenure_dv hhsize hhtype_dv hsctax hsownd hsrooms hsval ///
fihhmngrs_dv hhresp_dv hsyr04 hstotmg fborn hhdenui_xw ///
hidp hhsize hsrooms hsownd hsval hsyr04 hstotmg hsctax hhresp_dv ///
hhtype_dv nkids_dv nch02_dv nch34_dv nch511_dv nch1215_dv tenure_dv ///
fihhmngrs_dv wave rubrec fihhmnnet1_dv fihhmnlabgrs_dv fihhmnlabnet_dv fihhmngrs_if ///
fihhnegsei_if fihhmngrs_dv ///
save savreg finnow finfut qualoc payu paygl paytyp retdatey remit1 remit2 remit3 remit4 remit5  /// 
remitfreq1 remitreg1 remitamt1 remcntry1 remitusual1 remusamt1 remitfreq2 ///
remitreg2 remitamt2 remcntry2 remitusual2 remusamt2 remitfreq3 remitreg3 ///
remitamt3 remcntry3 remitusual3 remusamt3 remitfreq4 remitreg4 ///
remitamt4 remcntry4 remcntry4 remitusual4 remusamt4 qualoc lvrel3 lvrel4 ///
lvrel5 lvrel6 lvrel7 lvrel8 lvrel96 lkmove xpmove ctconsconf2 ///
ctconsconf3 ctconsconf4 ctconsconf5 ctconsconf6 ctconsconf7 xtra5min_dv	xtra5minosm_dv mvever ///
mvmnth mvyr lkmove xpmove citzn1 citzn2 citzn3 mabroad mnabroad mindirect mlived mnlived moveage ///
mreturned mintent mintwhen mnotherc mlivedist mlivedist5 mlivedistf ///
payruk payruk1 mayruk mayruk1 mayruk mayruk1 ///
qfvoc2 qfvoc3 qfvoc4 qfvoc5 qfvoc6 qfvoc7 qfvoc8 qfvoc9 qfvoc10 qfvoc11 qfvoc12 ///
qfvoc13 qfvoc14 qfvoc15 natid1 natid2 natid3 natid4 natid5 natid6 spaid smaid maage paage lvrel1 ///
lvrel2 oprlg englang oprlg mnmoves mlivedistf workdis worktrav lenindintv ctadd1_code ctadd2_code ///
cttown_code ctcnty_code ctpcode_code adcts movy11 movy12 movy13 movy14 movy15 ///
movy16 family education memploy housing area ///
moveoth_code movdir plnowm plnowy4 workdis worktrav jsttwt jsttwtb jsworkdis ///
jsworktrav j2has maage paage mafar pafar health finnow finfut vote1 ///
vote2 vote2 drive netuse mobuse ivtrans mvever ///
mvmnth mvyr health ///
country  ff_ukborn ff_yr2uk4 generation gor_dv housing indeflv ladistc ///
lkmvcntry locchd locsera locserap  locseras locserb locserc locserd locsere  ///
neigh neigh1 neigh2 neigh3 neigh4 neigh5 neigh6 opngbha opngbhb opngbhc opngbhd opngbhe ///
opngbhf opngbhg opngbhh plever region qfctry  xpmvcntry yr2uk ///
yr2uk4 yr2uk4 bornuk bornuk_dv distmov distmov hhmove hscimp  ///
 movest movjb movjba movjbb movjbc movjbd movjbe movjbf movjbg movjbh movjbi movy1 movy11 ///
 movy12 movy13 movy14 movy15 movy16 movy2 mreason1 mreason2 mreason3 mreason4 mreason5 ///
 mreason6 mreason7 mreason97 mreasono_code mvever mvmnth mvyr plb4c plb4d plnew plnowm plnowy4 ///
 nxdts  xdt1m xdt1pl xdt1y xdt2m xdt2pl xdt2y xdt3m xdt3pl xdt3y xdts adla adlad adlb adlbd adlc adlcd ///
 adld adldd adle adled adlf adlfd adlg adlgd adlh adlhd adli adlid adlj adljd adlk adlkd adll adlld adlm ///
 adlmd adln adlnd daywlk disdif1 disdif10 disdif11 disdif12 disdif2 disdif3 disdif4 disdif5 disdif6 ///
 disdif7 disdif8 disdif9 disdif96 dissev1 dissev10 dissev11 dissev12 dissev2 dissev3 dissev4 dissev5 dissev6 ///
 dissev7 dissev8 dissev9 hlend hllt hllta hlltb hlltc hlltd hllte hlltw hlltwa hlsf3a hlsf3b hlsf3c hlsf3d ///
 hlsf3e hlsf3g hlsf3h hlsf3i hlsf3j hlsf4a hlsf4b hlsf4c hlsf4d hlsf5a hlsf5b hlsf5c hlsf6 hlsf7 hlsf8 ///
 hlsf9j mlrnot11 rtcon2 rtlatd rtrlya scsf2b sf2a sf2b sf3a sf3b sf4a sf4b sf5 sf7 hl2hop hlprxb hlprxo ///
 hosp hospnhs hl2gp hl2hop  hlcka hlckan hlckb hlckbn  hlckc  hlckcn hlckd hlckdn hlcke hlcken hlckf ///
 hlckfn hlckg hlckgn hlckh hlckhn hlcki hlckin hlht hlprxa hlprxb hlprxg hlprxi hlprxj hlprxm hlprxo ///
 hlsve hlsvef hlsven hlsvf hlsvff hlsvfn hlsvg hlsvgf hlsvgn hlsvh hlsvhf hlsvhn hlsvi hlsvif hlsvin ///
 hlckan hlckbn hlckcn hlckdn hlcken hlckfn hlckgn  hlckhn  hlckin hlcvr hlcvrh hlcvrl hospnhs adla ///
 adlad adlb adlbd adlc adlcd adld adldd  adle adled adlf adlfd adlg adlgd adlh adlhd adli adlid adlj ///
 adljd adlk adlkd adll adlld adlm adlmd adln adlnd  disdif1 disdif10 disdif11 disdif12 disdif2 disdif3 ///
 disdif4 disdif5  disdif6 disdif7 disdif8 disdif9 dissev1 dissev10 dissev11 dissev12 dissev2 dissev3 ///
 dissev4 dissev5 dissev6 dissev7 dissev8 dissev9 hcond1 hcond10 hcond11 hcond12 hcond13 hcond14 hcond15 ///
 hcond16 hcond17 hcond18 hcond19 hcond2 hcond20 hcond3 hcond4 hcond5 hcond6 hcond7 hcond8 hcond9 hcond96 ///
 hconda01 hconda02 hconde6 hconde7 hconde96 hcondea6 hcondea7 hcondn1 hcondn10 hcondn11 hcondn12 hcondn13 ///
 hcondn14 hcondn15 hcondn16 hcondn17 hcondn18 hcondn19 hcondn2 hcondn20 hcondn3 hcondn4 hcondn5 hcondn6 ///
 hcondn7 hcondn8 hcondn9 hcondn96 hcondno_code health hlavpn hldsbl hldsbl1 hlendw hllt hllta hlltb  ///
 hlltd hllte hlltw hlltwa hlpain hlprb hlprba hlprbb hlprbc hlprbd hlprbe hlprbf hlprbg hlprbh hlprbi hlprbj ///
 hlprbk hlprbl hlprbm hlstat ind5mus_lw ind5mus_xw indbd91_lw indbdub_lw rtrhm ncigs smagbg smagbg_bh smcigs ///
 smever smoker lfsat1  lfsat2 lfsat3 lfsat4 lfsat5 lfsat6  lfsat7 lfsat8 lfsatl lfsato scghq1_dv ///
 scghq2_dv scghqa scghqb scghqc scghqd scghqe scghqf scghqg scghqh scghqi scghqj scghqk scghql sclfsat1 ///
 sclfsat2  sclfsat7 sclfsato scloutcont area family hhmove lvwhy ///
  moveoth_code  newhy newhy newhy neyrjn carown cd12use cd11use cd10use cd1use  cd3use  cd9use ///
 cdbght cdhave cduse1 cduse10 cduse11 cduse12 cduse13 cduse2 cduse3 cduse4 cduse5 cduse6 cduse7 cduse8 cduse9 ///
 cduse96 mgxty4 mobcomp mobuse pcbroad pcnet  xpfood xpfood1_g3 duelpay elecpay fuelduel fuelhave1 ///
 fuelhave2 fuelhave3 fuelhave4 fuelhave96 gaspay gasuse gasway heatch heatyp hheat hscana hscnta lecway xpbldf ///
 xpgasy hsip hsipxp mgxty2 mgxty2_bh f139  prf139  renthb renthb_bh  hsctax hs2ownd hsivlw hsjb ///
 hsownd hsownd_bh hsowndchk hsowr1_bh hsowr2_bh hsowrp hsroomchk hsrooms hstotmg hsyr04_bh hsyrbuy mghave mgynot ///
 mgynot_bh rentf rentll rentp0 rentp1 rentp1_bh tenure_dv tenure_dv hsprbg hsprbh hsprbi hsprbj hsprbk hsprbl ///
 hsprbm hsprbn hsprbo hsprbp hsprbq hscost hsval mgxty1 mgxty2 mgxty3 mgxty4 rent rentf rentg rentll xphsdb ///
 xpmg hsbeds  hsbeds hsbth fimngrs_dv fimnlabgrs_dv fimnnet_dv paynu_if prfitb prfitba bendis2  ///
 bendis3  bendis4 bendis5 bendis7 bendis97 benfam1 f101 f102 f103 f104 f105 f106 f107 fimnprben_dv ///
 fimnsben_dv pbnft1 pbnft10 pbnft11 pbnft12 pbnft13 pbnft2 pbnft3 pbnft4 pbnft5 pbnft6 pbnft7 pbnft8 pbnft9 pbnft96 ///
bensta2  f151 fihhmngrs_dv fihhmngrs_if fihhmninv_dv cdephave1 cdephave4 event1 lvhm lmar1m lmar1m lmar1m_dv lmar1y ///
lmar1y mlchm mlstatchk nmar mlstat_bh ///
marstat mastat mastat_dv mlchm mlstat mlstatchk mstatsam nonepar_dv aidhh aidhrs aidhu1  aidhu2 aidhua aidhub ///
aidhuc aidxhh caidu2 netuse pcnet pcoftn casmin feend fetype ftquals isced ///
nqfeda nqfedb nqfedc nqfedd nqfede nqfedf nqfedg nqfedh nqfedi nqfedj nqfedk nqfedl nqfedm nqfedn nqfedo ///
nqfedp nqfedq nqfedr nqfeds nqfedt prfehq prsehq qfachi fedasp fednt1 fednt2 ///
ff_emplw j1none jbhad jbsoc90ly jbstatl  ///
jlendy jlsemp spjbyr jbhhb jbhhc jbhhd jbhhe jlendm jles2000 movjb movjba movjbb movjbc ///
movjbd movjbe movjbf movjbg movjbh movjbi movy1 jlboss jlmngr jlsize ///
cjbatt depenth1 depenth2 depenth3 depenth4 depenth5 depenth6 diseffects1 diseffects2 /// 
diseffects3 jbsat jbsat_bh jbsat2 jbsat1 jbsat3 jbsat4 jbxpcha jbxpchb jbxpchc jbxpchd /// 
jbxpche jssat jssat1 jssat2 jssat4 mlrnot12 mlrnot13 mlrnot4 mlrnot6 mlrnot7 mlrnot9 /// 
mlrnot97 eprosh futrc futre futrf jbatt1 jbatt2 jbatt3 jbatt4 jbatt5 jbatt6 ///
 jbmngr jbmngrchk jbxpcha jbxpche juhrsl julkjb jwbs1_dv jwbs2_dv mlfutr ocimpa ocimpb ///
 ocimpe ocimpf ocimpi ocimpk j2hrs jbhhf jbhrlk jbhrs jbot jbotpd jbtime jbwkhra jbwkhrb ///
 jbwkhrc jbwkhrd jshrlk jshrs jstime j1none  j1soc00 j1soc00_cc jlseg_dv cjob employ employ ///
 jbbgm jbbgy jbft_dv jbsemp jbstat jbterm1 jbterm2 nemp_dv nemst prjbft  aideft cstat currstat1 /// 
 currstat2 currstat3 currstat4 currstat5 currstat6 julk4x1 julk4x4 julkjb ednew j2has j2hrs j2pay ///
 j2pay_dv j2paynet_dv  j2semp jbisco88 jbsect jbsectpub j2semp jlsemp jsaccs jsbgy4 jsboss ///
 jshrs jspart jspayu jspayw jspl jsprby4 jsprf jssize jsttwt jsttwtb jstypeb jsworktrav seearnnet_dv ///
 jbpen jbpenm basnsa basrate extrate j2pay_dv jbonus jbperfp jbrise jspayw paynl payu payug jbpl ///
 jbrgsc_dv jspl natida natidb natide natidf natidg natidh plbornc race ///
 racel wlshua wlshud wlshue chfar chsee huboss hubuys hufrys lvhm matlv  ncrr1 ncrr12 ncrr3 ///
 ncrr4 ncrr5 ncrr6 ncrr8 ncrr9 opfamk opfaml opfamo screlhappy chaid8 prfirn xphp xphpdf xphsd1 ///
 xphsd2 xphsdb xphsdba xphsdct xphsdf ftexv ftexw remit2 ftexa5 ftexb5 ftexc5 finnow fisitx fisity ///
 hlcvr hlcvrh hlcvrl hscana save saved savey1 savey2 savlt savreg windfa  windfay windfb windfby windfc ///
 windfcy windfd windfdy windff windffy windfg windfhy pppex pppexm retsuf sppen xpleis xpmeal xphp xphpdf ///
 xphsd1 xphsd2 xphsdb xphsdb_bh xphsdba xphsdct xphsdf fiyrdb1 fiyrdb2 fiyrdb3 fiyrdb4 fiyrdb5 fiyrdb6 ///
 fiyrdia fiyrdic remit4 save saved savey1 savey2 savlt savreg howlng huboss hubuys hufrys huiron humops hunurs ///
 husits huxpch jbchc1 jbchc2 jbchc3 attacked_dv avoided_dv hsprbg hsprbh hsprbi hsprbj hsprbp hsprbq lkmove ///
 lkmovy lknbrd movjb movjba movjbb movjbg movjbh movjbi plnew pplevr xpmove  adoptch01 adoptch02 adoptch03 ///
 adoptch04 adresp17 aidhh allch01  hgadoptf hgadoptm hgbiof hgbiom hgr2r ///
 hgra hhtype hhtype hoh mastat mlstat nchild_dv nchild_dv ncouple_dv nwed ppno pripn prrs2i ///
 rtfnd10 rtfnd2 rtfnd3 rtfnd4 rtfnd5 rtfnd6 rtfnd7 rtfnd8 rtfnd9 rtfnd96 rtpro1 rtpro2 rtpro3 rtpro4 rtpro5 rtpro6 ///
 huboss hufrys humops hunurs husits oprlg3 norga lactk orga norgm oprlg2 org orga j1cssf j1soc00 jlseg ///
 jlsoc90 chfar chsee frna frnb frnc maage macon mafar masee netag_1 netph_1 netpuse netsx_1 netsx1 paage ///
 pacon pafar parmar ssupa ssupb ssupc ssupd ssupe ypnpal age_dv agechy_dv birthy buno buno_dv ///
 citzn1 country eaage aidhrs howlng j2hrs jbhrs jbot jbotpd jbttwt jbwkhra jbwkhrb ///
 jbwkhrc jbwkhrd jbwkhrh jshrlk jshrs jstime jsttwt jsttwtb juhrsx lacta lactb lactc carown caruse jbttwm jbttwt jsttwt ///
 jsttwtb ageret finnow fisitx fisity hlstat hlzest jbhrlk jblkcha jblkchb jblkchc jbsat jbsat_bh jbsat1 jbsat2 ///
 jbsat4 jbsat5 jbsat6 jbsat7 jbxpcha jbxpchc jssat jssat1 jssat2 jssat4 jssat5 lfsat1 lfsat2 lfsat3 lfsat4 lfsat5 lfsat6 ///
 lfsat7 lfsat8 lfsato lfsatl lkmove lkmovy lknbrd ophla ophlb ophlc scghqa scghqb scghqc scghqd scghqe scghqf scghqg scghqh ///
 scghqi scghqj scghql sclfsat1 sclfsat2 sclfsat7 sclfsato ///
 pidp wave qfvoc15 qualnew31 trqual31 comwpas31 envhabit1 lenindintv nettalk10_1  netdo2_1 nettalk10_2 ///
netdo2_2 nettalk10_3 netdo2_3 tvm2 tvhours  debtinfo8  olympas11 olympas21  olympas31 netpuse julk4x3 ///
comwpas33  netuse olympas13  olympas23  olympas33 mobcomp scrf1  arts1b11 mobuse mobcomp  detinc2 ///
smartmob  detinc3 ctconsconf5 ctconsconf6 cttel2_code engtel teldif  phone_tm  debtinfo2 comwpas32 ///
olympas12 olympas22  olympas32 dvage age_dv pdvage scend  feend  dvage2uk age2ukc  dv2uk16 ageret ///
sex j1none j1semp j1boss  j1mngr currjob6  cjob jspayu  julk4x3 futre futrg jbsemp twkcarym  comtaxi ///
combus  comtrain commetro combike comwalk comother unsafe4 avoidance4   insulted4  attacked4 worktrav ///
jsworktrav unsafew12  avoidancew12  insultedw12  attackedw12  envhabit8 twkcary2 twkcary3  twkcary4 ///
twkcary5  twkcary7  acc1to169  acc1to1610  acc1to1611 acc1to1612 servaccy6  servaccy7 servaccy8 servaccy9 ///
locserc sattransy1 sattransy2 sattransy3  sattransy4 sattransy5 sattransy6 sattransy7  sattransy8  ///
sattransy9  sattransy10 sattransy97 visfrndsy5 visfrndsy6 visfamy4 visfamy5 visfamy6 caruse  altcar3 ///
altcar2 altcar4 altcar1  twkcarym altcar5 altcar6 altcar7 altcar8 altcar9 altcar10  altcar11 altcar12 ///
altcar96 altcar97 carshare carclub combike trbikefq   ynotbike1  ynotbike2 ynotbike3 ynotbike96 ///
ocimpa ocimpb  ocimpe ocimpf ocimpi ocimpk ocimpl jbsoc00chk fenow  fenow_cawi feend j1none  qfhigh_dv ///
nqfhigh_dv racel  simrace  racel_dv mlrnot11 resjobdeny5  scsf1 sclfsat1 scsf7 sf1 sf2a  sf2b sf3a ///
sf3b sf7 acc1to163  servaccy5 visfrndsy3 hconde6  hconde7 hconde96 respromdeny5 visfamy3  hcondno9 ///
hospc9 hospdc9 hcondns9 hcondno10 hospc10 hospdc10 hcondns10  hlthlink hlthkidlink healthsn intsignhealth ///
signhealthki1 signhealthki2 delay8 healthkidsn disdif11 dissev11 hlpforma1 hlpforma2 whodeal incass ///
scpayrea scpayreb anypayb  payamtb  payfreqb  allcostb  nopayb aidhh aidxhh  casch naidxhh ccare ///
disdif11 aidhh cmothpay11 hascurr  currynot2  currynot8 refbank refbnky svacts1 svacts2  infsave2 debt2 ///
debtinfo3 expmanage5 comwact36 scriska scriskb sctrust scriskb nbrcoh3 currynot8 delay5 scun2 scwhorupro ///
orgm10  orgmt10  orga10 orgat10 eatlivu  usbread2 paaid3  paidu3 chaid3  caidu3 eatlivu adlh adlhd ///
food1 food2 food3 food4 food5  food6 food7 nettalk12_1 nettalk12_2 nettalk12_3 rljoby3 breakfst wkfruit ///
fruitamt wkvege  vegeamt  adlh adlhd pregfert1 pregft11 pregft61  paaid4 caidu4  dinner  eatlivu ///
envhabit4 scenv_exag  sports14 sports34 netdo9_1 netdo9_2 netdo9_3 rleat carbuy12 delay8 adlk adlkd ///
sclfsat7  eatlivu   late  ps27 pjbptft sctimemnuf servaccy1 visfrndsy1  visfamy1 immstop4  sub7stop4 ///
nsstop4 delaystop4  vfstop4 nastop4 ypestb ypestf comwpas34  arts1b13  newsource1 newsource2 newsource3 ///
newsource4 newsource5 newsource6 newsource7 newsource8 newsource9  newsource10 newsource11  newsource12 ///
newsource96 newsmain paperm2 netm2 debtinfo9 olympas14 olympas24 olympas34 hlpinfa9 hlpinfb9 mlrnot10 ///
remit2  rtpro4 ypnpal  ypnetcht yajbsrv1 scenv_pmre scopngbhb scfrendany scfrely  scssup1 scssupr2r ///
simage simrace simeduc  simjob siminc simarea  simfam  closenum  netcht netag_1 netrl_1 netwr_1 netag_1 ///
netkn_1 netph_1 netlv_1 netjb_1   netet_1  netmet_1 netweb_1  nettalk1_1 nettalk2_1 nettalk3_1 nettalk4_1 ///
nettalk5_1  nettalk6_1 nettalk7_1  nettalk8_1  nettalk9_1 nettalk10_1 nettalk11_1 nettalk12_1  nettalk13_1 ///
nettalk97_1  nettalk96_1 netdo1_1   netdo2_1 netdo3_1 netdo4_1 netdo5_1 netdo6_1 netdo7_1 netdo8_1 ///
netdo9_1  netdo10_1 netdo97_1 netdo96_1 stendreas9   jbendreas9 nxtendreas9 mlrnot10 yajbsrv1  visfamy8 ///
visfamy9  infsave5   age_dv save savreg hiqual_dv jbstat jbsemp paygu_dv paynu_dv jbsat employ ///
qualoc payu paygl paytyp finnow finfut fimngrs_dv scend sex racel_dv marstat livesp_dv sclfsato country ///
urban_dv psu    mvever lkmove xpmove mnmoves mlivedist mlivedist5 plbornc istrtdatm istrtdaty jbpl health ///
indscus_lw indscus_xw wave sex age_dv adstatus agegr10_dv agegr13_dv agegr5_dv basnsa country employ ///
fenow fimngrs_dv fiyrinvinc_dv fnpno fnspid  gor_dv hidp indscus_lw indscus_xw istrtdat* jbbg* ///
jbft_dv jbmngr jbpl jbsec* jbsat jbstat jbsemp jbttwt livesp_dv marstat mastat_dv mlstat mnpno mnspid ///
nchild_dv hiqual_dv qfhigh_dv nnatch paygu_dv paynu_dv pid pno hidp hhorig memorig psu pid ppno ///
prearna sclfsato dvage2uk age2ukc dv2uk16 age2uk ///
 cduse3 cduse4 lenhhintv pcnet cduse10 cduse11  pcbroad hhtype_dv gpcomp cduse13 cduse12  cduse13 ff_tel ///
carage1 carage2 carage3 carage4 carage5 npensioner_dv nch02_dv nch34_dv nch511_dv nch1215_dv agechy_dv npens_dv ///
nwage_dv nchoecd_dv nadoecd_dv numadult numchild nunder15 nunder10 carage6 carage7 carage8 carage9 carage10 hsjb ///
nemp_dv nue_dv fihhnegsei_if ncars  mgxty3 carval ensze1 whodrive1  carn2h1 carfuel1 carage1 pdepa4 pdepb4 pdepc4 ///
pdepd4  pdepe4 pdepf4 pdepg4 pdeph4 pdepi4 pdepk4 pdepl4 pdepm4 pdepn4 pdepo4 othrec1 nvestrt2 xpfdout_g3 matdepb ///
xpfood1_g3 rentinc2 heatch solar2 matdepc hheat cdepdo5 matdepb cdepdo3 pdepoh5 cdephave1 hidp hhorig psu strata ///
month quarter ivfho hglieng addrchck origadd mores hhsize hhlang iemb fborn nkids05 nkids015 n10to15 nkids615 ///
npensioner hgstrtdaty hgstrtdatm hgstrtdatd hgstrtdathh hgenddaty hgenddatm hgenddatm hgenddatd modetype hlieng ///
hlitrans histrtdaty histrtdatm histrtdatd hsroomchk hsbeds hsrooms hsowndchk hsownd hsowr10 hsval mgynot hsyrbuy ///
hscost hsyr04 mgold mglife mgtype mgextra mgnew mgxty1 mgxty2 hstotmg xpmg hsjb rentp0 rentll rentf rentinc1 ///
rentinc2 rentinc3 rentwc rent rentg fuelhave1 fuelhave2 fuelhave3 fuelhave4 fuelhave96 gaspay xpoily xpsfly ///
heatch hsctax xphsdb xphsdct xphsdba pcnet ncars outcome npensioner_dv ff_hsownd fihhmnnet1_dv fihhmnlabgrs_dv ///
fihhmnlabnet_dv fihhmnmisc_dv fihhmnprben_dv fihhmninv_dv fihhmnpen_dv fihhmnsben_dv country gor_dv urban_dv ///
urban_dv hhresp_dv hhtype_dv hrpid hrpno ncouple_dv nonepar_dv nkids_dv nch02_dv nch34_dv nch511_dv agechy_dv ///
nch1215_dv npens_dv nemp_dv nue_dv nwage_dv nchoecd_dv nadoecd_dv ieqmoecd_dv tenure_dv fihhnegsei_if fihhmngrs_if ///
fihhmngrs_dv hhdenub_xw hhdenui_xw wave startdatd startdatm startdaty solar1 solar2 solar3 etariff rubrec matdepa ///
matdepb matdepd matdepe matdepf hheat cdephave1 cdephave2 cdephave3 cdephave4 cdepdo1 cdepdo2 cdepdo3 cplay ///
cdeptrp emboost gpcomp lda absent numadult numchild nunder15 nunder10 hhdenus_xw ff_hhsize histrtdatss hhdenbh_xw ///
noisyn grimyn ivlheng ivlhtrans nummpart numcivil numlivewith hhstatus lheng lhtrans nch02_dv nch1215_dv nch34_dv ///
nch511_dv nkids_dv rubrec wave tenure_dv hhsize hhtype_dv hsctax hsownd hsrooms hsval fihhmngrs_dv hhresp_dv ///
hsyr04 hstotmg fborn hhdenui_xw hidp hhsize hsrooms hsownd hsval hsyr04 hstotmg hsctax hhresp_dv hhtype_dv ///
nkids_dv nch02_dv nch34_dv nch511_dv nch1215_dv tenure_dv fihhmngrs_dv wave rubrec fihhmnnet1_dv fihhmnlabgrs_dv ///
fihhmnlabnet_dv fihhmngrs_if fihhnegsei_if fihhmngrs_dv hhsize hrpno hsbeds hsyrbuy rent hstotmg ///
fihhmngrs_if fihhmnnet1_dv ieqmoecd_dv hhsize xphsdb xphsdct xphsdba npens_dv nemp_dv nue_dv mgynot gor_dv hsval ///
hscost  tenure_dv ivfho iemb mgxty1 mgxty2 hhdenub_xw hhdenui_xw hhdenus_xw hhdenbh_xw

save "./dta/iCUL_main_data.dta", replace








//erase temp directory
!rmdir "./temp" /s /q
clear

//erase temp directory
!rmdir "./temp" /s /q
clear
************************ e.o.f. **************************



*GENERATION MODELS
**testing pooled panel
use "./dta/UKLS_HP.dta"
mvdecode pidp wave, mv(-11/-1)
sort pidp wave
xtset pidp wave




***to add variables from main dataset
use "./dta/UKLS_HP.dta"
mmerge pidp wave using "./dta/usindresp2_all7w.dta", ukeep (var)


*** help with stubborn file local i=0
**foreach v in a b c d e{
**local i=`i'+1
**use "C:\...\_`v'_wave.dta", clear
**gen wave=`i'
**rename `v'_x x
**rename `v'_y y
**rename `v'_z z


